-- [ja] ルール
--[[
	基本的にキー操作とサウンドはoverlayのほうで設定 
	楽曲情報や必要な変数、画面遷移もすべてoverlayで処理 
	他はあくまで表示内容だけ設定 
--]]
local t = LoadFallbackB();
local act = Def.ActorFrame{
	FOV=60;
	StartMessageCommand=cmd(playcommand,"Off");
	-- Left song
	-- Def.Sprite{
		-- InitCommand=cmd(scaletoclipped,160,160;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+16;addx,240;rotationy,-40;fadeleft,1;);
		-- SetSongMessageCommand=function(self,params)
			-- if params.Song then
				-- self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(1)));
			-- end;
			-- self:diffusealpha(0.1):zoom(0.6):decelerate(0.2):zoom(0.8):diffusealpha(0.4)
		-- end;
		-- OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
	-- };
	-- Selected song
		LoadActor("_notice") .. {
		Condition=not GAMESTATE:IsExtraStage2();
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+16;zoom,0.4;);
		OnCommand=cmd(diffusealpha,0;linear,2;diffusealpha,1);
		};
	-- Right song
	-- Def.Sprite{
		-- InitCommand=cmd(scaletoclipped,160,160;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+16;addx,-240;rotationy,40;faderight,1);
		-- SetSongMessageCommand=function(self,params)
			-- if params.Song then
				-- self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(-1)));
			-- end;
			-- self:diffusealpha(0.1):zoom(0.6):decelerate(0.2):zoom(0.8):diffusealpha(0.4)
		-- end;
		-- OffCommand=cmd(decelerate,0.3;diffusealpha,0);		
	-- };
	-- Song info
	LoadFont('Common Normal')..{
		InitCommand=cmd(Center;addy,120;strokecolor,0,0,0,1.0);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:settext(GetEXFSongState_Title(GetEXFCurrentSong()));
				self:diffuse(color("#FF674A")):strokecolor(color("#FF137D"));
				self:stoptweening():addy(-3):diffusealpha(0.0):smooth(0.2):addy(3):diffusealpha(1);
			else
				self:settext('');
			end;
		end;
	};
};

act[#act+1] = Def.ActorFrame{
	Condition=not GAMESTATE:IsExtraStage2();
	OnCommand=cmd(diffusealpha,0;sleep,0.5;linear,0.7;diffusealpha,1);
	LoadActor("_arrow") .. {
		InitCommand=cmd(zoom,0.5;y,SCREEN_CENTER_Y+16;x,SCREEN_CENTER_X-110);
		OnCommand=cmd(diffuseshift;effectcolor1,1,1,1,1.0;effectcolor2,1,1,1,0.4;effectperiod,2;);
	};
	LoadActor("_arrow") .. {
		InitCommand=cmd(zoom,0.5;y,SCREEN_CENTER_Y+16;x,SCREEN_CENTER_X+110;zoomx,-0.5);
		OnCommand=cmd(diffuseshift;effectcolor1,1,1,1,1.0;effectcolor2,1,1,1,0.4;effectperiod,2;);
	};	
};	

--act[#act+1] = Def.ActorFrame{
--	LoadActor("ScreenExSelectMenu music") .. {
--		OnCommand=cmd(play;);
--	};	
--};	
	
-- [ja] 難易度部分 
for pn in ivalues(PlayerNumber) do
	if GAMESTATE:IsPlayerEnabled(pn) then
		act[#act+1] = Def.ActorFrame{
			InitCommand=function(self)
				if pn==PLAYER_1 then
					(cmd(x,SCREEN_LEFT+160;y,SCREEN_CENTER_Y+20))(self);
				else
					(cmd(x,SCREEN_RIGHT-160;y,SCREEN_CENTER_Y+20))(self);
				end;
			end;
			-- [ja] プレイヤー番号 
			LoadActor("_nightcolor") .. {
				InitCommand=cmd(zoom,0.5;diffusealpha,0;);
				SetSongMessageCommand=function(self,params)
				if params.Song then
					local dif=GAMESTATE:GetCurrentSteps(pn):GetDifficulty();
					self:diffuse(CustomDifficultyToDarkColor(dif)):diffusealpha(1)
					end;
				end;
			};
			-- [ja] 難易度名 
			LoadFont('_troika 40px')..{
				InitCommand=cmd(zoom,0.5;addy,20;strokecolor,color("#000000"););
			    OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1;);
				OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0;);	
				SetSongMessageCommand=function(self,params)
					if params.Song then
						local dif=GAMESTATE:GetCurrentSteps(pn):GetDifficulty();
						self:diffuse(ColorLightTone(CustomDifficultyToColor(dif)));
						self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(dif)));
						else
						self:settext('');
					end;
				end;
			};
			-- [ja] 難易度数値（Hidden設定の場合は「??」になる） 
			LoadFont('_troika 40px')..{
				InitCommand=cmd(zoom,1.25;addy,-15);
				SetSongMessageCommand=function(self,params)
					if params.Song then
						local dif=GAMESTATE:GetCurrentSteps(pn):GetDifficulty();
						self:diffuse(CustomDifficultyToDarkColor(dif));
						if GetEXFCurrentSong_ShowStepInfo() then
							self:settext(GAMESTATE:GetCurrentSteps(pn):GetMeter());
								if GAMESTATE:GetCurrentSteps(pn):GetMeter() > 18 then
									self:diffuse(color("#FC7C7C"));
									self:strokecolor(color("#B00C0C"));
								elseif GAMESTATE:GetCurrentSteps(pn):GetMeter() > 15 then
									self:diffuse(color("#FCB988"));
									self:strokecolor(color("#B0500C"));
								else
									self:diffuse(color("#FFFFFF"));
									self:strokecolor(ColorDarkTone(CustomDifficultyToColor(dif)));
								end
						else
							self:settext('??');
						end;
					else
						self:settext('');
					end;
				end;
			};
		};
	end;
end;

t[#t+1] = act;
return t;